# Vibe Coding 全栈应用开发


你好，我是鱼皮。

这篇文章，我会带你做 3 个完整的全栈项目：个人博客系统、简易问答社区、在线商城（Mini 版）。

什么是全栈应用？

简单来说，就是既有前端界面，又有后端服务，还有数据库存储的完整应用。用户在前端操作，数据通过后端处理，最终保存到数据库中。这些项目会让你学习如何用 Vibe Coding 的方式开发前后端，处理用户认证、数据库操作等真实场景。

需要先说明的是，本节教程更多的是做一个思路和项目开发流程的指导，目的是引导大家学会使用 Vibe Coding 开发项目的方法，需要大家自行动手实践。如果你需要更完整的 Vibe Coding 图文和视频教程，可以看看鱼皮的原创项目实战部分。



## 一、全栈开发基础知识

在开始做项目之前，先了解一下全栈开发的基本概念。

全栈开发包括三个部分：前端（用户看到的界面）、后端（处理业务逻辑）、数据库（存储数据）。

前端负责展示数据和接收用户输入，后端负责处理请求和业务逻辑，数据库负责持久化存储。三者通过 API 接口进行通信。

![](https://pic.yupi.icu/1/fullstackarchitecture%E5%A4%A7.jpeg)

举个例子，当用户在博客网站上发布一篇文章时，前端会收集文章的标题、内容等信息，然后发送 HTTP 请求给后端。后端收到请求后，会验证数据是否合法，然后调用数据库接口把文章保存到数据库中。保存成功后，后端返回成功响应给前端，前端显示 “发布成功” 的提示。

主流的全栈技术栈有很多选择。对于 Vibe Coding 来说，我推荐使用现代化的、AI 友好的技术栈。前端可以用 React 或 Vue，后端可以用 Node.js（Express、Nest.js）或 Python（FastAPI），数据库可以用 MySQL、PostgreSQL 或 MongoDB。

但其实，具体用什么技术不是最重要的，重要的是理解全栈开发的思路。掌握了思路，换个技术栈也能很快上手。

用 Vibe Coding 开发全栈应用有个巨大的优势：你不需要精通前端和后端的所有细节，只需要知道要实现什么功能，AI 会帮你生成代码。

比如，你只需要告诉 AI：“创建一个用户注册接口，接收用户名、邮箱、密码，验证后保存到数据库。”

AI 就能帮你生成完整的后端代码，包括参数验证、密码加密、数据库操作等。这大大降低了全栈开发的门槛，让你可以专注于业务逻辑，而不是纠结于技术细节。



## 二、项目实战 - 个人博客系统

博客系统是最经典的全栈项目之一，涉及文章发布、分类管理、评论互动等功能。通过这个项目，你可以学习如何处理 CRUD（增删改查）操作，以及用户认证等基础功能。

这个博客系统要支持文章的发布、编辑、删除和查看。文章可以分类，支持标签。用户可以注册登录，发布自己的文章。访客可以浏览文章，但不能发布。文章支持 Markdown 格式，可以添加封面图。首页显示文章列表，支持分页和搜索。

![](https://pic.yupi.icu/1/demoweb10.png)

技术选型上，前端使用 React + TypeScript + Vite，样式用 Tailwind CSS。后端使用 Node.js + Express，数据库用 MySQL。用户认证用 JWT（JSON Web Token）。文章编辑器可以复用之前做过的 Markdown 编辑器。



### 开发步骤

1）设计数据库

开发的第一步是设计数据库。在开始写代码之前，先设计数据库结构。创建一个 `database.md` 文件，定义需要哪些表，每个表有哪些字段。

比如用户表需要：id（主键）、username（用户名，唯一）、email（邮箱，唯一）、password（密码，加密存储）、avatar（头像 URL）、created_at（创建时间）。

文章表需要：id、title（标题）、content（内容，Markdown 格式）、cover（封面图 URL）、category（分类）、tags（标签，JSON 数组）、author_id（作者 ID，外键关联 users）、views（浏览次数）、created_at、updated_at。

分类表需要：id、name（分类名称）、description（分类描述）。

2）写需求文档

设计好数据库后，就可以写需求文档了。创建 `PRD.md` 文件：

```markdown
# 个人博客系统 PRD

## 核心功能

### 用户功能
- 注册：用户名、邮箱、密码
- 登录：返回 JWT token
- 个人中心：查看和编辑个人信息

### 文章功能
- 发布文章：标题、内容、分类、标签、封面
- 编辑文章：修改已发布的文章
- 删除文章：只能删除自己的文章
- 查看文章：显示文章详情，浏览次数 +1
- 文章列表：支持分页、分类筛选、搜索

### 前端页面
- 首页：文章列表
- 文章详情页
- 写文章页（需要登录）
- 个人中心页（需要登录）
- 登录/注册页
```

3）与 AI 对话开发后端

有了文档，就可以和 AI 对话开发后端了。打开 Cursor，开始和 AI 对话。

第一步，初始化后端项目：

```
请创建一个 Node.js + Express 后端项目：
1. 初始化项目，安装 express、mysql2、jsonwebtoken、bcrypt 等依赖
2. 创建基本的项目结构：src/routes（路由）、src/controllers（控制器）、src/models（数据模型）、src/middleware（中间件）、src/config（配置）
3. 配置数据库连接
```

这个提示词说明了要创建什么项目，安装哪些依赖，项目结构是什么样的。

第二步，创建数据库表：

```
根据 database.md 中的设计，创建数据库表的 SQL 语句。然后创建一个初始化脚本，自动创建这些表。
```

AI 会根据你的数据库设计，生成创建表的 SQL 语句。

第三步，实现用户注册和登录：

```
实现用户注册和登录功能：

注册接口（POST /api/auth/register）：
- 接收 username、email、password
- 验证参数（用户名 3-20 字符，邮箱格式正确，密码至少 6 位）
- 检查用户名和邮箱是否已存在
- 密码用 bcrypt 加密
- 保存到数据库
- 返回成功信息

登录接口（POST /api/auth/login）：
- 接收 username、password
- 验证用户是否存在
- 验证密码是否正确
- 生成 JWT token（有效期 7 天）
- 返回 token 和用户信息
```

这个提示词详细说明了两个接口的功能要求。AI 会实现完整的注册和登录逻辑，包括参数验证、密码加密、JWT 生成等。

第四步，实现文章 CRUD：

```
实现文章的增删改查功能：

创建文章（POST /api/posts）：
- 需要登录（验证 JWT token）
- 接收 title、content、category、tags、cover
- author_id 从 token 中获取
- 保存到数据库
- 返回文章信息

获取文章列表（GET /api/posts）：
- 支持分页（page、pageSize）
- 支持分类筛选（category）
- 支持搜索（keyword，搜索标题和内容）
- 返回文章列表和总数

获取文章详情（GET /api/posts/:id）：
- 返回文章详情
- 浏览次数 +1

更新文章（PUT /api/posts/:id）：
- 需要登录
- 只能更新自己的文章
- 更新指定字段

删除文章（DELETE /api/posts/:id）：
- 需要登录
- 只能删除自己的文章
```

这个提示词包含了文章的所有操作。AI 会实现完整的 CRUD 功能，包括权限验证、数据查询等。

4）与 AI 对话开发前端

后端开发完成后，就可以开发前端了。建议先用 Postman 或类似工具测试后端接口，确保接口正常工作后再开发前端。这样可以避免前后端同时出问题，不知道问题出在哪里。

第一步，创建前端项目：

```
创建 React + TypeScript + Vite 前端项目，安装 react-router-dom、axios、react-markdown 等依赖。配置路由：
- / 首页（文章列表）
- /post/:id 文章详情
- /write 写文章（需要登录）
- /profile 个人中心（需要登录）
- /login 登录
- /register 注册
```

第二步，实现用户认证：

```
实现用户认证功能：
1. 创建 AuthContext，管理登录状态和用户信息
2. Token 存储在 localStorage
3. 封装 axios，自动在请求头添加 token
4. 创建 ProtectedRoute 组件，保护需要登录的页面
5. 实现登录和注册页面
```

这个提示词说明了用户认证的实现方式。AuthContext 用来管理全局的登录状态，ProtectedRoute 用来保护需要登录才能访问的页面。

第三步，实现文章列表页：

```
实现首页文章列表：
1. 获取文章列表，显示标题、封面、分类、作者、时间
2. 支持分页，每页 10 条
3. 支持分类筛选（顶部分类标签）
4. 支持搜索（搜索框）
5. 点击文章跳转到详情页
```

第四步，实现文章详情页：

```
实现文章详情页：
1. 根据 ID 获取文章详情
2. 使用 react-markdown 渲染文章内容
3. 显示作者信息、发布时间、浏览次数
4. 如果是自己的文章，显示编辑和删除按钮
```

第五步，实现写文章页：

```
实现写文章页：
1. 使用之前做的 Markdown 编辑器
2. 输入标题、选择分类、添加标签、上传封面
3. 左侧编辑，右侧实时预览
4. 保存按钮，调用创建文章接口
5. 如果是编辑模式，加载已有文章数据
```



### 开发技巧

在开发全栈应用时，有几个技巧可以提高效率。首先，使用环境变量管理配置。数据库连接信息、JWT 密钥等敏感信息不要硬编码在代码里，要用环境变量。创建 `.env` 文件，把配置放进去，然后在代码中通过 `process.env` 读取。

其次，要做好错误处理。API 调用可能失败，数据库操作可能出错，要捕获这些错误并返回友好的提示。可以让 AI 帮你创建一个统一的错误处理中间件。

最后，开发时可以使用 nodemon 自动重启后端服务，使用 Vite 的热更新功能自动刷新前端页面，这样修改代码后不需要手动重启，大大提高开发效率。



### 扩展思路

基础版完成后，可以继续扩展功能。比如添加评论系统，用户可以评论文章；添加点赞功能，给喜欢的文章点赞；支持文章草稿，保存未发布的文章；集成图片上传，上传到云存储；添加文章归档，按月份归档；支持 RSS 订阅，方便读者订阅；优化 SEO，让文章更容易被搜索引擎收录。



## 三、项目实战 - 问答社区

完成了博客系统后，让我们来挑战一个更复杂的项目 —— 问答社区。问答社区比博客系统更复杂一些，涉及问题、回答、点赞、采纳等互动功能。通过这个项目，你可以学习如何处理更复杂的数据关系和用户交互。

这个问答社区要支持用户提问和回答。用户可以发布问题，其他用户可以回答。问题和回答都支持点赞。提问者可以采纳最佳答案。首页显示问题列表，支持按热度、最新、未解决等排序。每个问题有标签，可以按标签筛选。用户有积分系统，提问、回答、被采纳都会获得积分。

![](https://pic.yupi.icu/1/demoweb11.png)

技术栈和博客系统类似，前端用 React + TypeScript + Vite，后端用 Node.js + Express，数据库用 MySQL。



### 开发步骤

1）设计数据库

开发的第一步是设计数据库。创建 `database.md` 文件：

```markdown
# 问答社区数据库设计

## 用户表（users）
- id、username、email、password、avatar
- points: 积分
- created_at

## 问题表（questions）
- id、title、content（Markdown）
- tags: 标签（JSON 数组）
- author_id: 提问者 ID
- views: 浏览次数
- answers_count: 回答数
- votes: 点赞数
- is_solved: 是否已解决
- created_at、updated_at

## 回答表（answers）
- id、content（Markdown）
- question_id: 问题 ID
- author_id: 回答者 ID
- votes: 点赞数
- is_accepted: 是否被采纳
- created_at、updated_at

## 点赞表（votes）
- id、user_id、target_type（question/answer）
- target_id: 目标 ID
- created_at
```

2）与 AI 对话开发

设计好数据库后，就可以和 AI 对话开发了。开发流程和博客系统类似，但要注意几个关键点。

第一个关键点是积分系统：

```
实现积分系统：
- 发布问题：-5 积分
- 回答问题：+10 积分
- 回答被采纳：+30 积分
- 问题被点赞：+5 积分
- 回答被点赞：+10 积分

在相应的操作中自动更新用户积分。
```

这个提示词说明了积分的规则。AI 会在实现功能时自动处理积分变化，比如用户回答问题后，自动给用户加 10 积分。

第二个关键点是点赞功能：

```
实现点赞功能：
- 用户可以点赞问题和回答
- 每个用户对同一个目标只能点赞一次
- 点赞后目标的 votes 数量 +1
- 取消点赞后 votes 数量 -1
- 返回用户是否已点赞的状态
```

点赞功能要防止重复点赞，所以需要记录用户的点赞行为。返回数据时要告诉前端用户是否已点赞，这样前端才能正确显示点赞按钮的状态。

第三个关键点是采纳答案：

```
实现采纳答案功能：
- 只有提问者可以采纳答案
- 每个问题只能采纳一个答案
- 采纳后问题状态变为已解决
- 回答者获得积分奖励
```

这个逻辑要在后端实现，确保权限控制正确。

第四个关键点是问题列表排序：

```
实现问题列表的多种排序：
- 最新：按创建时间倒序
- 热门：按点赞数倒序
- 未解决：筛选 is_solved = false 的问题
支持按标签筛选。
```



### 开发技巧

在开发问答社区时，有几个需要注意的地方。首先是数据一致性，比如点赞时，要同时更新点赞表和目标的 votes 数量，这两个操作要么都成功，要么都失败。可以让 AI 帮你实现数据库事务，确保数据一致性。

其次是性能优化。问题列表可能有很多数据，要做好分页。可以让 AI 帮你实现分页查询，每次只返回一页的数据，避免一次性加载太多数据导致页面卡顿。

另外，点赞状态的判断也很重要。在返回问题或回答列表时，要告诉前端当前用户是否已点赞，这样前端才能正确显示点赞按钮的状态（已点赞显示红色，未点赞显示灰色）。



### 扩展思路

基础版完成后，可以继续扩展功能。比如添加评论功能，对回答进行评论；添加关注功能，关注感兴趣的问题或用户；实现通知系统，有新回答时通知提问者；优化搜索功能，使用全文搜索提高搜索质量；添加排行榜，展示积分排名；实现徽章系统，完成成就获得徽章。



## 四、项目实战 - 在线商城

掌握了用户互动和积分系统后，让我们来做一个涉及交易流程的项目。在线商城是最复杂的全栈项目之一，涉及商品管理、购物车、订单处理等功能。通过这个项目，你可以学习如何处理电商业务逻辑。

这个 Mini 版商城要实现基本的电商功能。商品展示（列表和详情）、购物车（添加、删除、修改数量）、订单管理（创建订单、查看订单）、用户地址管理。不需要实现支付功能，订单创建后显示为待支付状态即可。这样可以降低开发难度，专注于核心业务流程。

![](https://pic.yupi.icu/1/demoweb12.png)

技术栈和前面的项目类似，前端用 React + TypeScript + Vite，后端用 Node.js + Express，数据库用 MySQL。



### 开发步骤

1）设计数据库

开发的第一步是设计数据库。创建 `database.md` 文件：

```markdown
# 在线商城数据库设计

## 用户表（users）
- id、username、email、password、avatar
- created_at

## 商品表（products）
- id、name、description、price、stock（库存）
- images: 图片 URL（JSON 数组）
- category: 分类
- created_at、updated_at

## 购物车表（cart_items）
- id、user_id、product_id、quantity（数量）
- created_at

## 地址表（addresses）
- id、user_id、name（收货人）、phone、province、city、district、detail
- is_default: 是否默认地址
- created_at

## 订单表（orders）
- id、order_no（订单号）、user_id、address_id
- total_price: 总价
- status: 状态（待支付、已支付、已发货、已完成、已取消）
- created_at、updated_at

## 订单商品表（order_items）
- id、order_id、product_id、quantity、price（下单时的价格）
```

2）与 AI 对话开发

设计好数据库后，就可以和 AI 对话开发了。开发流程和前面的项目类似，但要注意几个关键点。

第一个关键点是购物车功能：

```
实现购物车功能：

添加到购物车（POST /api/cart）：
- 接收 product_id、quantity
- 如果购物车已有该商品，数量累加
- 如果是新商品，创建新记录
- 检查库存是否充足

获取购物车（GET /api/cart）：
- 返回购物车商品列表
- 包含商品详情（名称、价格、图片等）
- 计算总价

更新数量（PUT /api/cart/:id）：
- 更新指定商品的数量
- 检查库存

删除商品（DELETE /api/cart/:id）：
- 从购物车删除指定商品
```

购物车功能要处理好商品数量的累加，还要检查库存，避免加入超过库存的数量。

第二个关键点是订单功能：

```
实现订单功能：

创建订单（POST /api/orders）：
- 接收 address_id 和购物车商品 ID 列表
- 检查库存是否充足
- 计算总价
- 生成订单号（时间戳 + 随机数）
- 创建订单和订单商品记录
- 扣减库存
- 清空购物车中已下单的商品
- 使用数据库事务确保数据一致性

获取订单列表（GET /api/orders）：
- 返回用户的订单列表
- 支持按状态筛选
- 包含订单商品详情

获取订单详情（GET /api/orders/:id）：
- 返回订单详情
- 包含收货地址、订单商品列表

取消订单（PUT /api/orders/:id/cancel）：
- 只能取消待支付的订单
- 恢复库存
- 更新订单状态为已取消
```

这个提示词包含了订单的所有操作。创建订单是最复杂的，涉及多个表的操作，要使用数据库事务确保数据一致性。

第三个关键点是地址管理：

```
实现地址管理功能：

添加地址（POST /api/addresses）：
- 接收收货人信息
- 如果设置为默认地址，将其他地址的 is_default 设为 false

获取地址列表（GET /api/addresses）：
- 返回用户的地址列表
- 默认地址排在前面

更新地址（PUT /api/addresses/:id）：
- 更新指定地址

删除地址（DELETE /api/addresses/:id）：
- 删除指定地址
- 如果删除的是默认地址，将第一个地址设为默认
```



### 开发技巧

在开发电商系统时，有几个关键点需要特别注意。首先是库存管理，创建订单时要检查库存，扣减库存时要使用数据库事务，确保不会出现超卖的情况。可以让 AI 帮你实现乐观锁或悲观锁来处理并发问题。

其次是订单号的生成。订单号要唯一，可以用时间戳加随机数，或者用雪花算法。可以让 AI 帮你实现一个订单号生成函数。

另外，购物车和订单的关系要处理好。创建订单时，要把购物车中的商品信息复制到订单商品表，而不是直接引用购物车。因为商品价格可能会变化，订单要保存下单时的价格，这样才能保证订单金额不会因为商品价格变化而变化。

最后，要做好数据校验。比如数量不能为负数，价格不能为负数，库存不能为负数等。可以让 AI 帮你在后端添加完整的参数校验，避免脏数据进入数据库。



### 扩展思路

基础版完成后，可以继续扩展功能。比如添加商品搜索和筛选，按价格、分类、销量等筛选；添加商品评价，用户可以评价购买的商品；实现优惠券系统，支持满减、折扣等优惠；集成支付功能，接入支付宝或微信支付；添加订单物流跟踪，查看物流信息；开发商家后台管理，管理商品和订单；实现商品推荐算法，根据用户喜好推荐商品。



## 写在最后

通过这 3 个全栈项目，你已经学习了完整的 Web 应用开发流程：从简单的博客系统，到复杂的问答社区，再到涉及交易流程的在线商城。每个项目都让你掌握了不同的业务场景和技术点。

全栈开发看起来很复杂，但用 Vibe Coding 的方式，你会发现其实并没有想象中那么难。关键是要理解业务逻辑，知道要实现什么功能，然后让 AI 帮你生成代码。如果你想学习更多的全栈开发技巧和最佳实践，可以参考本教程的经验技巧板块。

掌握了全栈应用开发后，在下一篇文章中，我会带你学习微信小程序开发，让你的应用可以在微信中运行，触达更多用户。



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
